import yaml
from dataclasses import dataclass

@dataclass
class StudyConfig:
    study_id: str
    size_rule: str
    sizes_csv: str
    mode: str
    alphaP: float
    UGM_phys_m: float
    R_obs_m: float
    c_ms: float
    lambda_G_default: float
    S_s2: float
    use_outer_window_only: bool
    dvdr_max_kms_per_kpc: float
    min_window_points: int
    min_radius_kpc: float
    min_window_span_kpc: float
    nbins: int
    low_g_nbins: int
    mesh_max_rel_delta: float

def load_study_config(path: str) -> 'StudyConfig':
    with open(path,'r') as f:
        y = yaml.safe_load(f)
    return StudyConfig(
        study_id=y['study_id'],
        size_rule=y['size_rule'],
        sizes_csv=y.get('sizes_csv','data/galaxy_sizes.csv'),
        mode=y['mode'],
        alphaP=float(y.get('alphaP',0.0)),
        UGM_phys_m=float(y.get('UGM_phys_m',0.0)),
        R_obs_m=float(y.get('R_obs_m',0.0)),
        c_ms=float(y.get('c_ms',299792458.0)),
        lambda_G_default=float(y.get('lambda_G_default',1.0)),
        S_s2=float(y.get('S_s2',0.0)),
        use_outer_window_only=bool(y.get('use_outer_window_only',True)),
        dvdr_max_kms_per_kpc=float(y['dvdr_max_kms_per_kpc']),
        min_window_points=int(y['min_window_points']),
        min_radius_kpc=float(y['min_radius_kpc']),
        min_window_span_kpc=float(y['min_window_span_kpc']),
        nbins=int(y['nbins']),
        low_g_nbins=int(y['low_g_nbins']),
        mesh_max_rel_delta=float(y['mesh_max_rel_delta']),
    )
